#!/usr/bin/env python

from renki.srv.lib import check_settings
from renki.srv.lib import renki_settings as settings
from renki.srv.lib.handler import task_manager
from renki.common.communication.client import RenkiClient
from time import sleep
from renki.common.exceptions import NotAuthenticated
import logging

import renki.modules.dummy.srv
import renki.modules.port.srv

def main():
    check_settings.set_settings()
    logger = logging.getLogger('server')

    logger.info("Starting server")

    r = RenkiClient(settings.RENKI_ADDRESS)
    r.auth(settings.RENKI_LOGIN_NAME, settings.RENKI_LOGIN_PASSWORD)

    logger.debug("Authenticated to RenkiCore")

    task_manager.start_all()

    try:
        while True:
            logger.info('Polling tasks from core')
            try:
                data = r.get('tickets/%s' % settings.RENKI_SRV_NAME)
            except NotAuthenticated:
                logger.info('Server returned not authenticated. Trying to authenticate again')
                r.auth(settings.RENKI_LOGIN_NAME, settings.RENKI_LOGIN_PASSWORD)
                continue
            except Exception as e:
                logger.exception("Failed to parse")
                continue

            print(data)

            # TODO : validate format of data
            for ticket in data['tickets']:
                task_type = ticket['ticket_module']
                task_manager.dispatch_task(task_type, task=ticket)
            sleep(data['next_poll'])
    except KeyboardInterrupt:
        pass

    logger.info('Stopping RenkiSRV')
    task_manager.stop_all()
    logger.info('Waiting for task handlers to stop')
    task_manager.join_all()
    logger.info('Server stopped')

if __name__ == '__main__':
    main()
